CREATE OR REPLACE FUNCTION addindex() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
     if exists (select 1 from information_schema.table_constraints where table_name = 'est_orc_cpl_pbm' and constraint_name = 'est_orc_cpl_pbm_cd_emp_fkey') then
		ALTER TABLE IF EXISTS public.est_orc_cpl_pbm DROP CONSTRAINT IF EXISTS est_orc_cpl_pbm_cd_emp_fkey;
	 end if; 
	if exists (select 1 from information_schema.table_constraints where table_name = 'est_orc_cpl_pbm' and constraint_name = 'est_orc_cpl_pbm_cd_emp_cd_filial_cd_orc_cd_it_fkey'  ) then
		ALTER TABLE IF EXISTS public.est_orc_cpl_pbm DROP CONSTRAINT IF EXISTS est_orc_cpl_pbm_cd_emp_cd_filial_cd_orc_cd_it_fkey;
	end if; 
	IF exists (SELECT 1 from pg_indexes WHERE tablename= 'est_orc_cpl' and INDEXNAME='est_orc_cpl_pkey') THEN 
		ALTER TABLE est_orc_cpl DROP CONSTRAINT est_orc_cpl_pkey;
		raise notice 'est_orc_cpl_pkey DROPADA COM SUCESSO';

		ALTER TABLE est_orc_cpl ADD CONSTRAINT est_orc_cpl_pkey PRIMARY KEY (cd_emp, cd_filial, cd_orc, cd_it);
		raise notice 'est_orc_cpl_pkey CRIADA ';
	else 
		ALTER TABLE IF EXISTS est_orc_cpl ADD CONSTRAINT est_orc_cpl_pkey PRIMARY KEY (cd_emp, cd_filial, cd_orc, cd_it);
		raise notice 'est_orc_cpl_pkey CRIADA ';
    END IF;
END;


$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addindex() OWNER TO postgres; 
SELECT addindex(); 
DROP FUNCTION addindex();


CREATE OR REPLACE FUNCTION addindex() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF exists (SELECT 1 from pg_indexes WHERE tablename= 'est_orc_cpl_pbm' and INDEXNAME='est_orc_cpl_pbm_cd_emp_fkey') THEN 
		ALTER TABLE IF EXISTS est_orc_cpl_pbm DROP CONSTRAINT est_orc_cpl_pbm_cd_emp_fkey;
		ALTER TABLE IF EXISTS est_orc_cpl_pbm  ADD CONSTRAINT est_orc_cpl_pbm_cd_emp_fkey FOREIGN KEY (cd_emp, cd_filial, cd_orc, cd_it)
		REFERENCES public.est_orc_cpl (cd_emp, cd_filial, cd_orc, cd_it) MATCH SIMPLE
		ON UPDATE NO ACTION
		ON DELETE NO ACTION;
		raise notice 'est_orc_cpl_pbm_cd_emp_fkey CRIADA ';
	else 
		ALTER TABLE IF EXISTS est_orc_cpl_pbm  ADD CONSTRAINT est_orc_cpl_pbm_cd_emp_fkey FOREIGN KEY (cd_emp, cd_filial, cd_orc, cd_it)
		REFERENCES public.est_orc_cpl (cd_emp, cd_filial, cd_orc, cd_it) MATCH SIMPLE
		ON UPDATE NO ACTION
		ON DELETE NO ACTION;
		raise notice 'est_orc_cpl_pbm_cd_emp_fkey CRIADA ';
    END IF;
END;

$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addindex() OWNER TO postgres; 
SELECT addindex(); 
DROP FUNCTION addindex();
